<?xml version="1.0" encoding="UTF-8"?>
<app:application xmlns:app="http://www.sierrawireless.com/airvantage/application/1.0"
    type="ODYSSEY"
    name="AirLink OS RX55"
    revision="5.3.66">
    <capabilities>
        <communication>
            <protocol comm-id="SERIAL" type="LWM2M">
                <parameter name="dtls" value="psk"/>
                <parameter name="version" value="core=1_0-20170208"/>
            </protocol>
        </communication>
        <dm>
            <action impl="AIRLINKOS_COAP_REBOOT"/>
            <action impl="AIRLINKOS_COAP_RESET"/>
            <action impl="AIRLINKOS_COAP_FW_UPDATE"/>
            <action impl="AIRLINKOS_COAP_RETRIEVE_LOGS"/>
            <action impl="AIRLINKOS_COAP_CONFIGURE_HEARTBEAT"/>
            <action impl="AIRLINKOS_COAP_SYNCHRONIZE"/>
            <action impl="AIRLINKOS_COAP_CERT_RENEW"/>
            <action impl="AIRLINKOS_COAP_CERT_REGENERATE"/>
        </dm>
        <data>
            <encoding type="LWM2M">
                <asset id="system.codeset.action" default-label="Software Image Management">
                    <command path="rollback" default-label="Switch To Backup Image"/>
                    <command path="sync" default-label="Synchronize Backup Partition"/>
                </asset>
            </encoding>
        </data>
    </capabilities>
    <mappings>
        <mapping source="services.lwm2m.state.revision" target="_FIRMWARE_VERSION"/>
        <mapping source="device.machine" target="_FIRMWARE_TYPE"/>
        <mapping source="device.provisioning.variant" target="_DEVICE_VARIANT"/>
        <mapping source="system.init.resetcount" target="_NUMBER_OF_RESETS"/>
        <mapping source="location.gnss.latitude" target="_LATITUDE"/>
        <mapping source="location.gnss.longitude" target="_LONGITUDE"/>
        <mapping source="location.gnss.altitude" target="_ALTITUDE"/>
        <mapping source="location.gnss.qi" target="_GNSS_QI"/>
        <mapping source="system.mcu.voltage.value" target="_VOLTAGE"/>
        <mapping source="system.mcu.temperature.value" target="_BOARD_TEMP"/>
        <mapping source="system.hybridcloud.enable" target="_SIGN_MODE"/>
        <mapping source="system.security.certificates[Hybrid Cloud CA].notafter" target="_ROOT_CERT_EXPIRY_DATE"/>

        <mapping source="system.hardware.expansion[ExpansionL].serial" target="_CARTRIDGE_HSN_1"/>
        <mapping source="system.hardware.expansion[ExpansionL].present" target="_CARTRIDGE_PRESENCE_1"/>

        <mapping source="system.hardware.expansion[ExpansionR].serial" target="_CARTRIDGE_HSN_2"/>
        <mapping source="system.hardware.expansion[ExpansionR].present" target="_CARTRIDGE_PRESENCE_2"/>

        <mapping source="net.interface.cellular[c1].band" target="_CELLULAR_BAND"/>
        <mapping source="net.interface.cellular[c1].rat" target="_CELLULAR_RAT"/>
        <mapping source="net.interface.cellular[c1].channel" target="_CELLULAR_CHANNEL"/>
        <mapping source="net.interface.cellular[c1].msim.simpresence" target="_SIM_PRESENCE"/>
        <mapping source="net.interface.cellular[c1].imsi" target="_IMSI_ESN_MEID"/>
        <mapping source="net.interface.cellular[c1].iccid" target="_ICCID"/>
        <mapping source="net.interface.cellular[c1].apninuse" target="_APN"/>
        <mapping source="net.interface.cellular[c1].cellid" target="_CELL_ID"/>
        <mapping source="net.interface.cellular[c1].rssi" target="_RSSI"/>
        <mapping source="net.interface.cellular[c1].ecio" target="_ECIO"/>
        <mapping source="net.interface.cellular[c1].rsrp" target="_RSRP"/>
        <mapping source="net.interface.cellular[c1].rsrq" target="_RSRQ"/>
        <mapping source="net.interface.cellular[c1].technology.current" target="_NETWORK_SERVICE_TYPE"/>
        <mapping source="net.interface.cellular[c1].roamingstring" target="_ROAMING_STATUS"/>
        <mapping source="net.interface.cellular[c1].operator" target="_OPERATOR"/>
        <mapping source="net.interface.cellular[c1].bars" target="_SIGNAL_BARS"/>
        <mapping source="net.interface.cellular[c1].firmware.current.modelid" target="_RADIO_MODULE"/>
        <mapping source="net.interface.cellular[c1].temperature.value" target="_RADIO_MODULE_TEMP"/>
        <mapping source="net.interface.common[c1].tx.bytes" target="_BYTES_SENT"/>
        <mapping source="net.interface.common[c1].rx.bytes" target="_BYTES_RECEIVED"/>
        <mapping source="net.interface.common[c1].tx.packets" target="_PACKETS_SENT"/>
        <mapping source="net.interface.common[c1].rx.packets" target="_PACKETS_RECEIVED"/>
        <mapping source="net.interface.common[c1].ipv4.address" target="_IP_ADDRESS"/>
        <mapping source="net.interface.common[c1].ipv6.address" target="_IP_ADDRESS_V6"/>
        <mapping source="net.interface.cellular[c1].snr" target="_SNR"/>
        <mapping source="net.interface.cellular[c1].imei" target="_IMEI"/>
        <mapping source="net.interface.cellular[c1].voicenumber" target="_MOBILE_NUMBER"/>
        <mapping source="net.interface.cellular[c1].firmware.current.application" target="_RM_FW_VERSION"/>


        <mapping source="net.interface.cellular[c3].band" target="_CELLULAR_BAND_1"/>
        <mapping source="net.interface.cellular[c3].rat" target="_CELLULAR_RAT_1"/>
        <mapping source="net.interface.cellular[c3].channel" target="_CELLULAR_CHANNEL_1"/>
        <mapping source="net.interface.cellular[c3].msim.simpresence" target="_SIM_PRESENCE_1"/>
        <mapping source="net.interface.cellular[c3].imsi" target="_IMSI_ESN_MEID_1"/>
        <mapping source="net.interface.cellular[c3].iccid" target="_ICCID_1"/>
        <mapping source="net.interface.cellular[c3].apninuse" target="_APN_1"/>
        <mapping source="net.interface.cellular[c3].cellid" target="_CELL_ID_1"/>
        <mapping source="net.interface.cellular[c3].rssi" target="_RSSI_1"/>
        <mapping source="net.interface.cellular[c3].ecio" target="_ECIO_1"/>
        <mapping source="net.interface.cellular[c3].rsrp" target="_RSRP_1"/>
        <mapping source="net.interface.cellular[c3].rsrq" target="_RSRQ_1"/>
        <mapping source="net.interface.cellular[c3].technology.current" target="_NETWORK_SERVICE_TYPE_1"/>
        <mapping source="net.interface.cellular[c3].roamingstring" target="_ROAMING_STATUS_1"/>
        <mapping source="net.interface.cellular[c3].operator" target="_OPERATOR_1"/>
        <mapping source="net.interface.cellular[c3].bars" target="_SIGNAL_BARS_1"/>
        <mapping source="net.interface.cellular[c3].firmware.current.modelid" target="_RADIO_MODULE_1"/>
        <mapping source="net.interface.cellular[c3].temperature.value" target="_RADIO_MODULE_TEMP_1"/>
        <mapping source="net.interface.common[c3].tx.bytes" target="_BYTES_SENT_1"/>
        <mapping source="net.interface.common[c3].rx.bytes" target="_BYTES_RECEIVED_1"/>
        <mapping source="net.interface.common[c3].tx.packets" target="_PACKETS_SENT_1"/>
        <mapping source="net.interface.common[c3].rx.packets" target="_PACKETS_RECEIVED_1"/>
        <mapping source="net.interface.common[c3].ipv4.address" target="_IP_ADDRESS_1"/>
        <mapping source="net.interface.common[c3].ipv6.address" target="_IP_ADDRESS_V6_1"/>
        <mapping source="net.interface.cellular[c3].snr" target="_SNR_1"/>
        <mapping source="net.interface.cellular[c3].imei" target="_IMEI_1"/>
        <mapping source="net.interface.cellular[c3].voicenumber" target="_MOBILE_NUMBER_1"/>
        <mapping source="net.interface.cellular[c3].firmware.current.application" target="_RM_FW_VERSION_1"/>

        <mapping source="net.interface.cellular[c4].band" target="_CELLULAR_BAND_1"/>
        <mapping source="net.interface.cellular[c4].rat" target="_CELLULAR_RAT_1"/>
        <mapping source="net.interface.cellular[c4].channel" target="_CELLULAR_CHANNEL_1"/>
        <mapping source="net.interface.cellular[c4].msim.simpresence" target="_SIM_PRESENCE_1"/>
        <mapping source="net.interface.cellular[c4].imsi" target="_IMSI_ESN_MEID_1"/>
        <mapping source="net.interface.cellular[c4].iccid" target="_ICCID_1"/>
        <mapping source="net.interface.cellular[c4].apninuse" target="_APN_1"/>
        <mapping source="net.interface.cellular[c4].cellid" target="_CELL_ID_1"/>
        <mapping source="net.interface.cellular[c4].rssi" target="_RSSI_1"/>
        <mapping source="net.interface.cellular[c4].ecio" target="_ECIO_1"/>
        <mapping source="net.interface.cellular[c4].rsrp" target="_RSRP_1"/>
        <mapping source="net.interface.cellular[c4].rsrq" target="_RSRQ_1"/>
        <mapping source="net.interface.cellular[c4].technology.current" target="_NETWORK_SERVICE_TYPE_1"/>
        <mapping source="net.interface.cellular[c4].roamingstring" target="_ROAMING_STATUS_1"/>
        <mapping source="net.interface.cellular[c4].operator" target="_OPERATOR_1"/>
        <mapping source="net.interface.cellular[c4].bars" target="_SIGNAL_BARS_1"/>
        <mapping source="net.interface.cellular[c4].firmware.current.modelid" target="_RADIO_MODULE_1"/>
        <mapping source="net.interface.cellular[c4].temperature.value" target="_RADIO_MODULE_TEMP_1"/>
        <mapping source="net.interface.common[c4].tx.bytes" target="_BYTES_SENT_1"/>
        <mapping source="net.interface.common[c4].rx.bytes" target="_BYTES_RECEIVED_1"/>
        <mapping source="net.interface.common[c4].tx.packets" target="_PACKETS_SENT_1"/>
        <mapping source="net.interface.common[c4].rx.packets" target="_PACKETS_RECEIVED_1"/>
        <mapping source="net.interface.common[c4].ipv4.address" target="_IP_ADDRESS_1"/>
        <mapping source="net.interface.common[c4].ipv6.address" target="_IP_ADDRESS_V6_1"/>
        <mapping source="net.interface.cellular[c4].snr" target="_SNR_1"/>
        <mapping source="net.interface.cellular[c4].imei" target="_IMEI_1"/>
        <mapping source="net.interface.cellular[c4].voicenumber" target="_MOBILE_NUMBER_1"/>
        <mapping source="net.interface.cellular[c4].firmware.current.application" target="_RM_FW_VERSION_1"/>


        <mapping source="net.interface.cellular[c2].band" target="_CELLULAR_BAND_2"/>
        <mapping source="net.interface.cellular[c2].rat" target="_CELLULAR_RAT_2"/>
        <mapping source="net.interface.cellular[c2].channel" target="_CELLULAR_CHANNEL_2"/>
        <mapping source="net.interface.cellular[c2].msim.simpresence" target="_SIM_PRESENCE_2"/>
        <mapping source="net.interface.cellular[c2].imsi" target="_IMSI_ESN_MEID_2"/>
        <mapping source="net.interface.cellular[c2].iccid" target="_ICCID_2"/>
        <mapping source="net.interface.cellular[c2].apninuse" target="_APN_2"/>
        <mapping source="net.interface.cellular[c2].cellid" target="_CELL_ID_2"/>
        <mapping source="net.interface.cellular[c2].rssi" target="_RSSI_2"/>
        <mapping source="net.interface.cellular[c2].ecio" target="_ECIO_2"/>
        <mapping source="net.interface.cellular[c2].rsrp" target="_RSRP_2"/>
        <mapping source="net.interface.cellular[c2].rsrq" target="_RSRQ_2"/>
        <mapping source="net.interface.cellular[c2].technology.current" target="_NETWORK_SERVICE_TYPE_2"/>
        <mapping source="net.interface.cellular[c2].roamingstring" target="_ROAMING_STATUS_2"/>
        <mapping source="net.interface.cellular[c2].operator" target="_OPERATOR_2"/>
        <mapping source="net.interface.cellular[c2].bars" target="_SIGNAL_BARS_2"/>
        <mapping source="net.interface.cellular[c2].firmware.current.modelid" target="_RADIO_MODULE_2"/>
        <mapping source="net.interface.cellular[c2].temperature.value" target="_RADIO_MODULE_TEMP_2"/>
        <mapping source="net.interface.common[c2].tx.bytes" target="_BYTES_SENT_2"/>
        <mapping source="net.interface.common[c2].rx.bytes" target="_BYTES_RECEIVED_2"/>
        <mapping source="net.interface.common[c2].tx.packets" target="_PACKETS_SENT_2"/>
        <mapping source="net.interface.common[c2].rx.packets" target="_PACKETS_RECEIVED_2"/>
        <mapping source="net.interface.common[c2].ipv4.address" target="_IP_ADDRESS_2"/>
        <mapping source="net.interface.common[c2].ipv6.address" target="_IP_ADDRESS_V6_2"/>
        <mapping source="net.interface.cellular[c2].snr" target="_SNR_2"/>
        <mapping source="net.interface.cellular[c2].imei" target="_IMEI_2"/>
        <mapping source="net.interface.cellular[c2].voicenumber" target="_MOBILE_NUMBER_2"/>
        <mapping source="net.interface.cellular[c2].firmware.current.application" target="_RM_FW_VERSION_2"/>

        <mapping source="net.interface.cellular[c5].band" target="_CELLULAR_BAND_2"/>
        <mapping source="net.interface.cellular[c5].rat" target="_CELLULAR_RAT_2"/>
        <mapping source="net.interface.cellular[c5].channel" target="_CELLULAR_CHANNEL_2"/>
        <mapping source="net.interface.cellular[c5].msim.simpresence" target="_SIM_PRESENCE_2"/>
        <mapping source="net.interface.cellular[c5].imsi" target="_IMSI_ESN_MEID_2"/>
        <mapping source="net.interface.cellular[c5].iccid" target="_ICCID_2"/>
        <mapping source="net.interface.cellular[c5].apninuse" target="_APN_2"/>
        <mapping source="net.interface.cellular[c5].cellid" target="_CELL_ID_2"/>
        <mapping source="net.interface.cellular[c5].rssi" target="_RSSI_2"/>
        <mapping source="net.interface.cellular[c5].ecio" target="_ECIO_2"/>
        <mapping source="net.interface.cellular[c5].rsrp" target="_RSRP_2"/>
        <mapping source="net.interface.cellular[c5].rsrq" target="_RSRQ_2"/>
        <mapping source="net.interface.cellular[c5].technology.current" target="_NETWORK_SERVICE_TYPE_2"/>
        <mapping source="net.interface.cellular[c5].roamingstring" target="_ROAMING_STATUS_2"/>
        <mapping source="net.interface.cellular[c5].operator" target="_OPERATOR_2"/>
        <mapping source="net.interface.cellular[c5].bars" target="_SIGNAL_BARS_2"/>
        <mapping source="net.interface.cellular[c5].firmware.current.modelid" target="_RADIO_MODULE_2"/>
        <mapping source="net.interface.cellular[c5].temperature.value" target="_RADIO_MODULE_TEMP_2"/>
        <mapping source="net.interface.common[c5].tx.bytes" target="_BYTES_SENT_2"/>
        <mapping source="net.interface.common[c5].rx.bytes" target="_BYTES_RECEIVED_2"/>
        <mapping source="net.interface.common[c5].tx.packets" target="_PACKETS_SENT_2"/>
        <mapping source="net.interface.common[c5].rx.packets" target="_PACKETS_RECEIVED_2"/>
        <mapping source="net.interface.common[c5].ipv4.address" target="_IP_ADDRESS_2"/>
        <mapping source="net.interface.common[c5].ipv6.address" target="_IP_ADDRESS_V6_2"/>
        <mapping source="net.interface.cellular[c5].snr" target="_SNR_2"/>
        <mapping source="net.interface.cellular[c5].imei" target="_IMEI_2"/>
        <mapping source="net.interface.cellular[c5].voicenumber" target="_MOBILE_NUMBER_2"/>
        <mapping source="net.interface.cellular[c5].firmware.current.application" target="_RM_FW_VERSION_2"/>

        <!-- External Modems -->
        <mapping source="net.external.cellular[e1].firmware.current.application" target="_RM_FW_VERSION_EXT_1"/>
        <mapping source="net.external.cellular[e1].imei" target="_IMEI_EXT_1"/>
        <mapping source="net.external.cellular[e1].iccid" target="_ICCID_EXT_1"/>
        <mapping source="net.external.cellular[e1].imsi" target="_IMSI_ESN_MEID_EXT_1"/>
        <mapping source="net.external.common[e1].tx.bytes" target="_BYTES_SENT_EXT_1"/>
        <mapping source="net.external.common[e1].rx.bytes" target="_BYTES_RECEIVED_EXT_1"/>
        <mapping source="net.external.common[e1].ipv4.address" target="_IP_ADDRESS_EXT_1"/>
        <mapping source="net.external.common[e1].ipv6.address" target="_IP_ADDRESS_V6_EXT_1"/>
        <mapping source="net.external.cellular[e1].technology.current" target="_NETWORK_SERVICE_TYPE_EXT_1"/>
        <mapping source="net.external.cellular[e1].rat" target="_CELLULAR_RAT_EXT_1"/>
        <mapping source="net.external.cellular[e1].rsrp" target="_RSRP_EXT_1"/>
        <mapping source="net.external.cellular[e1].rsrq" target="_RSRQ_EXT_1"/>
        <mapping source="net.external.cellular[e1].rssi" target="_RSSI_EXT_1"/>
        <mapping source="net.external.cellular[e1].snr" target="_SNR_EXT_1"/>
        <mapping source="net.external.cellular[e1].band" target="_CELLULAR_BAND_EXT_1"/>
        <mapping source="net.external.cellular[e1].cellid" target="_CELL_ID_EXT_1"/>
        <mapping source="net.external.cellular[e1].homeoperator" target="_OPERATOR_EXT_1"/>
        <mapping source="net.external.cellular[e1].apninuse" target="_APN_EXT_1"/>
        <mapping source="net.external.cellular[e1].bars" target="_SIGNAL_BARS_EXT_1"/>
        <mapping source="net.external.cellular[e1].voicenumber" target="_MOBILE_NUMBER_EXT_1"/>
        <mapping source="net.external.cellular[e1].channel" target="_CELLULAR_CHANNEL_EXT_1"/>
        <mapping source="net.external.cellular[e1].ecio" target="_ECIO_EXT_1"/>
        <mapping source="net.external.cellular[e1].temperature.value" target="_RADIO_MODULE_TEMP_EXT_1"/>
        <mapping source="net.external.common[e1].tx.packets" target="_PACKETS_SENT_EXT_1"/>
        <mapping source="net.external.common[e1].rx.packets" target="_PACKETS_RECEIVED_EXT_1"/>

        <mapping source="net.external.cellular[e2].firmware.current.application" target="_RM_FW_VERSION_EXT_2"/>
        <mapping source="net.external.cellular[e2].imei" target="_IMEI_EXT_2"/>
        <mapping source="net.external.cellular[e2].iccid" target="_ICCID_EXT_2"/>
        <mapping source="net.external.cellular[e2].imsi" target="_IMSI_ESN_MEID_EXT_2"/>
        <mapping source="net.external.common[e2].tx.bytes" target="_BYTES_SENT_EXT_2"/>
        <mapping source="net.external.common[e2].rx.bytes" target="_BYTES_RECEIVED_EXT_2"/>
        <mapping source="net.external.common[e2].ipv4.address" target="_IP_ADDRESS_EXT_2"/>
        <mapping source="net.external.common[e2].ipv6.address" target="_IP_ADDRESS_V6_EXT_2"/>
        <mapping source="net.external.cellular[e2].technology.current" target="_NETWORK_SERVICE_TYPE_EXT_2"/>
        <mapping source="net.external.cellular[e2].rat" target="_CELLULAR_RAT_EXT_2"/>
        <mapping source="net.external.cellular[e2].rsrp" target="_RSRP_EXT_2"/>
        <mapping source="net.external.cellular[e2].rsrq" target="_RSRQ_EXT_2"/>
        <mapping source="net.external.cellular[e2].rssi" target="_RSSI_EXT_2"/>
        <mapping source="net.external.cellular[e2].snr" target="_SNR_EXT_2"/>
        <mapping source="net.external.cellular[e2].band" target="_CELLULAR_BAND_EXT_2"/>
        <mapping source="net.external.cellular[e2].cellid" target="_CELL_ID_EXT_2"/>
        <mapping source="net.external.cellular[e2].homeoperator" target="_OPERATOR_EXT_2"/>
        <mapping source="net.external.cellular[e2].apninuse" target="_APN_EXT_2"/>
        <mapping source="net.external.cellular[e2].bars" target="_SIGNAL_BARS_EXT_2"/>
        <mapping source="net.external.cellular[e2].voicenumber" target="_MOBILE_NUMBER_EXT_2"/>
        <mapping source="net.external.cellular[e2].channel" target="_CELLULAR_CHANNEL_EXT_2"/>
        <mapping source="net.external.cellular[e2].ecio" target="_ECIO_EXT_2"/>
        <mapping source="net.external.cellular[e2].temperature.value" target="_RADIO_MODULE_TEMP_EXT_2"/>
        <mapping source="net.external.common[e2].tx.packets" target="_PACKETS_SENT_EXT_2"/>
        <mapping source="net.external.common[e2].rx.packets" target="_PACKETS_RECEIVED_EXT_2"/>

        <mapping source="net.external.cellular[e3].firmware.current.application" target="_RM_FW_VERSION_EXT_3"/>
        <mapping source="net.external.cellular[e3].imei" target="_IMEI_EXT_3"/>
        <mapping source="net.external.cellular[e3].iccid" target="_ICCID_EXT_3"/>
        <mapping source="net.external.cellular[e3].imsi" target="_IMSI_ESN_MEID_EXT_3"/>
        <mapping source="net.external.common[e3].tx.bytes" target="_BYTES_SENT_EXT_3"/>
        <mapping source="net.external.common[e3].rx.bytes" target="_BYTES_RECEIVED_EXT_3"/>
        <mapping source="net.external.common[e3].ipv4.address" target="_IP_ADDRESS_EXT_3"/>
        <mapping source="net.external.common[e3].ipv6.address" target="_IP_ADDRESS_V6_EXT_3"/>
        <mapping source="net.external.cellular[e3].technology.current" target="_NETWORK_SERVICE_TYPE_EXT_3"/>
        <mapping source="net.external.cellular[e3].rat" target="_CELLULAR_RAT_EXT_3"/>
        <mapping source="net.external.cellular[e3].rsrp" target="_RSRP_EXT_3"/>
        <mapping source="net.external.cellular[e3].rsrq" target="_RSRQ_EXT_3"/>
        <mapping source="net.external.cellular[e3].rssi" target="_RSSI_EXT_3"/>
        <mapping source="net.external.cellular[e3].snr" target="_SNR_EXT_3"/>
        <mapping source="net.external.cellular[e3].band" target="_CELLULAR_BAND_EXT_3"/>
        <mapping source="net.external.cellular[e3].cellid" target="_CELL_ID_EXT_3"/>
        <mapping source="net.external.cellular[e3].homeoperator" target="_OPERATOR_EXT_3"/>
        <mapping source="net.external.cellular[e3].apninuse" target="_APN_EXT_3"/>
        <mapping source="net.external.cellular[e3].bars" target="_SIGNAL_BARS_EXT_3"/>
        <mapping source="net.external.cellular[e3].voicenumber" target="_MOBILE_NUMBER_EXT_3"/>
        <mapping source="net.external.cellular[e3].channel" target="_CELLULAR_CHANNEL_EXT_3"/>
        <mapping source="net.external.cellular[e3].ecio" target="_ECIO_EXT_3"/>
        <mapping source="net.external.cellular[e3].temperature.value" target="_RADIO_MODULE_TEMP_EXT_3"/>
        <mapping source="net.external.common[e3].tx.packets" target="_PACKETS_SENT_EXT_3"/>
        <mapping source="net.external.common[e3].rx.packets" target="_PACKETS_RECEIVED_EXT_3"/>

        <mapping source="net.external.cellular[e4].firmware.current.application" target="_RM_FW_VERSION_EXT_4"/>
        <mapping source="net.external.cellular[e4].imei" target="_IMEI_EXT_4"/>
        <mapping source="net.external.cellular[e4].iccid" target="_ICCID_EXT_4"/>
        <mapping source="net.external.cellular[e4].imsi" target="_IMSI_ESN_MEID_EXT_4"/>
        <mapping source="net.external.common[e4].tx.bytes" target="_BYTES_SENT_EXT_4"/>
        <mapping source="net.external.common[e4].rx.bytes" target="_BYTES_RECEIVED_EXT_4"/>
        <mapping source="net.external.common[e4].ipv4.address" target="_IP_ADDRESS_EXT_4"/>
        <mapping source="net.external.common[e4].ipv6.address" target="_IP_ADDRESS_V6_EXT_4"/>
        <mapping source="net.external.cellular[e4].technology.current" target="_NETWORK_SERVICE_TYPE_EXT_4"/>
        <mapping source="net.external.cellular[e4].rat" target="_CELLULAR_RAT_EXT_4"/>
        <mapping source="net.external.cellular[e4].rsrp" target="_RSRP_EXT_4"/>
        <mapping source="net.external.cellular[e4].rsrq" target="_RSRQ_EXT_4"/>
        <mapping source="net.external.cellular[e4].rssi" target="_RSSI_EXT_4"/>
        <mapping source="net.external.cellular[e4].snr" target="_SNR_EXT_4"/>
        <mapping source="net.external.cellular[e4].band" target="_CELLULAR_BAND_EXT_4"/>
        <mapping source="net.external.cellular[e4].cellid" target="_CELL_ID_EXT_4"/>
        <mapping source="net.external.cellular[e4].homeoperator" target="_OPERATOR_EXT_4"/>
        <mapping source="net.external.cellular[e4].apninuse" target="_APN_EXT_4"/>
        <mapping source="net.external.cellular[e4].bars" target="_SIGNAL_BARS_EXT_4"/>
        <mapping source="net.external.cellular[e4].voicenumber" target="_MOBILE_NUMBER_EXT_4"/>
        <mapping source="net.external.cellular[e4].channel" target="_CELLULAR_CHANNEL_EXT_4"/>
        <mapping source="net.external.cellular[e4].ecio" target="_ECIO_EXT_4"/>
        <mapping source="net.external.cellular[e4].temperature.value" target="_RADIO_MODULE_TEMP_EXT_4"/>
        <mapping source="net.external.common[e4].tx.packets" target="_PACKETS_SENT_EXT_4"/>
        <mapping source="net.external.common[e4].rx.packets" target="_PACKETS_RECEIVED_EXT_4"/>

        <mapping source="net.external.cellular[e5].firmware.current.application" target="_RM_FW_VERSION_EXT_5"/>
        <mapping source="net.external.cellular[e5].imei" target="_IMEI_EXT_5"/>
        <mapping source="net.external.cellular[e5].iccid" target="_ICCID_EXT_5"/>
        <mapping source="net.external.cellular[e5].imsi" target="_IMSI_ESN_MEID_EXT_5"/>
        <mapping source="net.external.common[e5].tx.bytes" target="_BYTES_SENT_EXT_5"/>
        <mapping source="net.external.common[e5].rx.bytes" target="_BYTES_RECEIVED_EXT_5"/>
        <mapping source="net.external.common[e5].ipv4.address" target="_IP_ADDRESS_EXT_5"/>
        <mapping source="net.external.common[e5].ipv6.address" target="_IP_ADDRESS_V6_EXT_5"/>
        <mapping source="net.external.cellular[e5].technology.current" target="_NETWORK_SERVICE_TYPE_EXT_5"/>
        <mapping source="net.external.cellular[e5].rat" target="_CELLULAR_RAT_EXT_5"/>
        <mapping source="net.external.cellular[e5].rsrp" target="_RSRP_EXT_5"/>
        <mapping source="net.external.cellular[e5].rsrq" target="_RSRQ_EXT_5"/>
        <mapping source="net.external.cellular[e5].rssi" target="_RSSI_EXT_5"/>
        <mapping source="net.external.cellular[e5].snr" target="_SNR_EXT_5"/>
        <mapping source="net.external.cellular[e5].band" target="_CELLULAR_BAND_EXT_5"/>
        <mapping source="net.external.cellular[e5].cellid" target="_CELL_ID_EXT_5"/>
        <mapping source="net.external.cellular[e5].homeoperator" target="_OPERATOR_EXT_5"/>
        <mapping source="net.external.cellular[e5].apninuse" target="_APN_EXT_5"/>
        <mapping source="net.external.cellular[e5].bars" target="_SIGNAL_BARS_EXT_5"/>
        <mapping source="net.external.cellular[e5].voicenumber" target="_MOBILE_NUMBER_EXT_5"/>
        <mapping source="net.external.cellular[e5].channel" target="_CELLULAR_CHANNEL_EXT_5"/>
        <mapping source="net.external.cellular[e5].ecio" target="_ECIO_EXT_5"/>
        <mapping source="net.external.cellular[e5].temperature.value" target="_RADIO_MODULE_TEMP_EXT_5"/>
        <mapping source="net.external.common[e5].tx.packets" target="_PACKETS_SENT_EXT_5"/>
        <mapping source="net.external.common[e5].rx.packets" target="_PACKETS_RECEIVED_EXT_5"/>

        <mapping source="net.external.cellular[e6].firmware.current.application" target="_RM_FW_VERSION_EXT_6"/>
        <mapping source="net.external.cellular[e6].imei" target="_IMEI_EXT_6"/>
        <mapping source="net.external.cellular[e6].iccid" target="_ICCID_EXT_6"/>
        <mapping source="net.external.cellular[e6].imsi" target="_IMSI_ESN_MEID_EXT_6"/>
        <mapping source="net.external.common[e6].tx.bytes" target="_BYTES_SENT_EXT_6"/>
        <mapping source="net.external.common[e6].rx.bytes" target="_BYTES_RECEIVED_EXT_6"/>
        <mapping source="net.external.common[e6].ipv4.address" target="_IP_ADDRESS_EXT_6"/>
        <mapping source="net.external.common[e6].ipv6.address" target="_IP_ADDRESS_V6_EXT_6"/>
        <mapping source="net.external.cellular[e6].technology.current" target="_NETWORK_SERVICE_TYPE_EXT_6"/>
        <mapping source="net.external.cellular[e6].rat" target="_CELLULAR_RAT_EXT_6"/>
        <mapping source="net.external.cellular[e6].rsrp" target="_RSRP_EXT_6"/>
        <mapping source="net.external.cellular[e6].rsrq" target="_RSRQ_EXT_6"/>
        <mapping source="net.external.cellular[e6].rssi" target="_RSSI_EXT_6"/>
        <mapping source="net.external.cellular[e6].snr" target="_SNR_EXT_6"/>
        <mapping source="net.external.cellular[e6].band" target="_CELLULAR_BAND_EXT_6"/>
        <mapping source="net.external.cellular[e6].cellid" target="_CELL_ID_EXT_6"/>
        <mapping source="net.external.cellular[e6].homeoperator" target="_OPERATOR_EXT_6"/>
        <mapping source="net.external.cellular[e6].apninuse" target="_APN_EXT_6"/>
        <mapping source="net.external.cellular[e6].bars" target="_SIGNAL_BARS_EXT_6"/>
        <mapping source="net.external.cellular[e6].voicenumber" target="_MOBILE_NUMBER_EXT_6"/>
        <mapping source="net.external.cellular[e6].channel" target="_CELLULAR_CHANNEL_EXT_6"/>
        <mapping source="net.external.cellular[e6].ecio" target="_ECIO_EXT_6"/>
        <mapping source="net.external.cellular[e6].temperature.value" target="_RADIO_MODULE_TEMP_EXT_6"/>
        <mapping source="net.external.common[e6].tx.packets" target="_PACKETS_SENT_EXT_6"/>
        <mapping source="net.external.common[e6].rx.packets" target="_PACKETS_RECEIVED_EXT_6"/>

        <mapping source="net.external.cellular[e7].firmware.current.application" target="_RM_FW_VERSION_EXT_7"/>
        <mapping source="net.external.cellular[e7].imei" target="_IMEI_EXT_7"/>
        <mapping source="net.external.cellular[e7].iccid" target="_ICCID_EXT_7"/>
        <mapping source="net.external.cellular[e7].imsi" target="_IMSI_ESN_MEID_EXT_7"/>
        <mapping source="net.external.common[e7].tx.bytes" target="_BYTES_SENT_EXT_7"/>
        <mapping source="net.external.common[e7].rx.bytes" target="_BYTES_RECEIVED_EXT_7"/>
        <mapping source="net.external.common[e7].ipv4.address" target="_IP_ADDRESS_EXT_7"/>
        <mapping source="net.external.common[e7].ipv6.address" target="_IP_ADDRESS_V6_EXT_7"/>
        <mapping source="net.external.cellular[e7].technology.current" target="_NETWORK_SERVICE_TYPE_EXT_7"/>
        <mapping source="net.external.cellular[e7].rat" target="_CELLULAR_RAT_EXT_7"/>
        <mapping source="net.external.cellular[e7].rsrp" target="_RSRP_EXT_7"/>
        <mapping source="net.external.cellular[e7].rsrq" target="_RSRQ_EXT_7"/>
        <mapping source="net.external.cellular[e7].rssi" target="_RSSI_EXT_7"/>
        <mapping source="net.external.cellular[e7].snr" target="_SNR_EXT_7"/>
        <mapping source="net.external.cellular[e7].band" target="_CELLULAR_BAND_EXT_7"/>
        <mapping source="net.external.cellular[e7].cellid" target="_CELL_ID_EXT_7"/>
        <mapping source="net.external.cellular[e7].homeoperator" target="_OPERATOR_EXT_7"/>
        <mapping source="net.external.cellular[e7].apninuse" target="_APN_EXT_7"/>
        <mapping source="net.external.cellular[e7].bars" target="_SIGNAL_BARS_EXT_7"/>
        <mapping source="net.external.cellular[e7].voicenumber" target="_MOBILE_NUMBER_EXT_7"/>
        <mapping source="net.external.cellular[e7].channel" target="_CELLULAR_CHANNEL_EXT_7"/>
        <mapping source="net.external.cellular[e7].ecio" target="_ECIO_EXT_7"/>
        <mapping source="net.external.cellular[e7].temperature.value" target="_RADIO_MODULE_TEMP_EXT_7"/>
        <mapping source="net.external.common[e7].tx.packets" target="_PACKETS_SENT_EXT_7"/>
        <mapping source="net.external.common[e7].rx.packets" target="_PACKETS_RECEIVED_EXT_7"/>

    </mappings>
    <application-manager use="UNITY_FW" config="upgradeMilestones=4.0"/>
    <binaries>
        <binary file="RX55-5.3.66.ufw" type="FULL"/>
    </binaries>
</app:application>
